<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
ini_set( 'display_errors', 1 );
require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

$coin_list = array();

$res = mysqli_query($con, "SELECT * FROM order_coin_2 where status = 1");
while ($row = $res->fetch_assoc()) {
  $coin_list[] = str_replace(' ', '', $row['code']);
}

$coin_list = array_unique($coin_list); 

function getCloseShortSignal($symbol = 'BTCUSDT', $interval = '15m', $limit = 100): array {
    // Fetch kline data
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $data = json_decode(file_get_contents($url), true);

    if (!$data || !is_array($data)) {
        return ['error' => 'Failed to fetch candle data'];
    }

    // Extract close prices
    $closes = array_map(function($candle) {
        return floatval($candle[4]); // Closing price
    }, $data);

    // Calculate RSI
    $rsi = calculateRSI($closes, 14);

    // Calculate short and long MAs
    $ma_short = movingAverage($closes, 5);
    $ma_long  = movingAverage($closes, 20);

    // Last values
    $last_rsi = end($rsi);
    $prev_rsi = $rsi[count($rsi) - 2] ?? $last_rsi;

    $last_ma_short = end($ma_short);
    $prev_ma_short = $ma_short[count($ma_short) - 2] ?? $last_ma_short;
    $last_ma_long = end($ma_long);
    $prev_ma_long = $ma_long[count($ma_long) - 2] ?? $last_ma_long;

    // Signal: Close SHORT when RSI drops below 70 AND short MA starts crossing above long MA
    $rsi_condition = $prev_rsi > 70 && $last_rsi < 70;
    $ma_crossover = $prev_ma_short < $prev_ma_long && $last_ma_short > $last_ma_long;

    $signal = ($rsi_condition && $ma_crossover) ? "CLOSE SHORT" : "HOLD";

    return [
        'symbol' => $symbol,
        'interval' => $interval,
        'rsi' => round($last_rsi, 2),
        'ma_short' => round($last_ma_short, 2),
        'ma_long' => round($last_ma_long, 2),
        'signal' => $signal
    ];
}

function getCloseLongSignal($symbol = 'BTCUSDT', $interval = '15m', $limit = 100): array {
    // Step 1: Fetch Binance candle data
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $data = json_decode(file_get_contents($url), true);

    if (!$data || !is_array($data)) {
        return ['error' => 'Failed to fetch candle data'];
    }

    // Step 2: Extract closing prices
    $closes = array_map(function($candle) {
        return floatval($candle[4]); // Closing price
    }, $data);

    // Step 3: Calculate RSI
    $rsi = calculateRSI($closes, 14);

    // Step 4: Calculate Moving Averages
    $ma_short = movingAverage($closes, 5);   // fast MA
    $ma_long  = movingAverage($closes, 20);  // slow MA

    // Step 5: Analyze signal
    $last_rsi = end($rsi);
    $prev_rsi = $rsi[count($rsi) - 2] ?? $last_rsi;

    $last_ma_short = end($ma_short);
    $prev_ma_short = $ma_short[count($ma_short) - 2] ?? $last_ma_short;
    $last_ma_long = end($ma_long);
    $prev_ma_long = $ma_long[count($ma_long) - 2] ?? $last_ma_long;

    // Condition: RSI crossed below 70 and MA crossover down
    $rsi_condition = $prev_rsi > 70 && $last_rsi < 70;
    $ma_cross_down = $prev_ma_short > $prev_ma_long && $last_ma_short < $last_ma_long;

    $signal = ($rsi_condition && $ma_cross_down) ? "CLOSE LONG" : "HOLD";

    return [
        'symbol' => $symbol,
        'interval' => $interval,
        'rsi' => round($last_rsi, 2),
        'ma_short' => round($last_ma_short, 2),
        'ma_long' => round($last_ma_long, 2),
        'signal' => $signal
    ];
}

function calculateRSI($closes, $period = 14): array {
    $rsi = [];
    $gains = $losses = [];

    for ($i = 1; $i < count($closes); $i++) {
        $change = $closes[$i] - $closes[$i - 1];
        $gains[] = max(0, $change);
        $losses[] = max(0, -$change);
    }

    $avg_gain = array_sum(array_slice($gains, 0, $period)) / $period;
    $avg_loss = array_sum(array_slice($losses, 0, $period)) / $period;

    for ($i = $period; $i < count($gains); $i++) {
        $avg_gain = (($avg_gain * ($period - 1)) + $gains[$i]) / $period;
        $avg_loss = (($avg_loss * ($period - 1)) + $losses[$i]) / $period;
        $rs = $avg_loss == 0 ? 100 : $avg_gain / $avg_loss;
        $rsi[] = 100 - (100 / (1 + $rs));
    }

    return $rsi;
}

function movingAverage($data, $period): array {
    $ma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = array_sum(array_slice($data, $i - $period + 1, $period));
        $ma[] = $sum / $period;
    }
    return $ma;
}

if(!empty($coin_list)){
    foreach($coin_list As $code){
        $sql = 'SELECT * FROM order_coin_2 where code = "'.$code.'" AND status = 1';
        $result = mysqli_query($con, $sql);
        $row   = mysqli_fetch_assoc($result);  
        if(!empty($row)){ 
            if($row['type']=='L'){ 
                $result = getCloseLongSignal($code, '15m');
                if($result['signal']=='CLOSE LONG'){
                    $resultjson = json_encode($result);
                    
                $sql = 'UPDATE order_coin_2 SET status = 0, close_ma_short = "'.$result['ma_short'].'", close_ma_long = "'.$result['ma_long'].'", close_time = "'.date('Y-m-d H:i:s').'"  WHERE code ="'.$code.'"';
                mysqli_query($con, $sql);
                
                }
            }elseif($row['type']=='S'){ 
                $result = getCloseShortSignal($code, '15m');
                if($result['signal']=='CLOSE LONG'){
                    $resultjson = json_encode($result);
                    
                $sql = 'UPDATE order_coin_2 SET status = 0, close_ma_short = "'.$result['ma_short'].'", close_ma_long = "'.$result['ma_long'].'", close_time = "'.date('Y-m-d H:i:s').'"  WHERE code ="'.$code.'"';
                mysqli_query($con, $sql);
                
                }
            }
        }
    }
}

if(!empty($result) && $result['signal']!='HOLD'){
$mail = new PHPMailer;
$mail->isSMTP(); 
$mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
$mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
$mail->Port = 465; // TLS only
$mail->SMTPSecure = 'ssl'; // ssl is depracated
$mail->SMTPAuth = true;
$mail->Username = 'binance@easywayb.com';
$mail->Password = 'VignzC;&?i29';
$mail->setFrom('binance@easywayb.com', 'binance');
//$mail->addReplyTo('@gmail.com', ' Name');
$mail->addAddress('info@easywayb.com', 'priyankar');
$mail->Subject = 'Binance signal for '.$code;
$mail->msgHTML($resultjson); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
//$mail->AltBody = 'HTML messaging not supported';
// $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file

if(!$mail->send()){
   // echo "Mailer Error: " . $mail->ErrorInfo;
}else{
    //echo "Message sent!";
    echo $resultjson;
    
}
}