<?php
date_default_timezone_set("Asia/Calcutta");
$time = date('Gi');
exit;
$st_time_1    =   strtotime(date('H:i:s', strtotime('04:20:00')));
$end_time_1   =   strtotime(date('H:i:s', strtotime('04:45:00')));

$st_time_2    =   strtotime(date('H:i:s', strtotime('06:20:00')));
$end_time_2   =   strtotime(date('H:i:s', strtotime('06:45:00')));

$st_time_3    =   strtotime(date('H:i:s', strtotime('21:20:00')));
$end_time_3   =   strtotime(date('H:i:s', strtotime('21:45:00')));

$st_time_4    =   strtotime(date('H:i:s', strtotime('08:20:00')));
$end_time_4   =   strtotime(date('H:i:s', strtotime('08:45:00')));

$cur_time   =   time();

if(($st_time_1 < $cur_time && $end_time_1 > $cur_time) || ($st_time_2 < $cur_time && $end_time_2 > $cur_time) || ($st_time_3 < $cur_time && $end_time_3 > $cur_time) || ($st_time_4 < $cur_time && $end_time_4 > $cur_time))
{
   echo "Trading start";
}
else{
   exit;
}


function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.15) {
    if (empty($klines)) return null;

    // Get highs from klines
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}


function getKlines($symbol, $interval = '1h', $limit = 100) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function calculateSMA($data, $period) {
    $sma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = 0;
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function calculateRSI($prices, $period = 14) {
    $gains = $losses = [];
    for ($i = 1; $i <= $period; $i++) {
        $diff = $prices[$i] - $prices[$i - 1];
        if ($diff >= 0) $gains[] = $diff;
        else $losses[] = abs($diff);
    }
    $avgGain = array_sum($gains) / $period;
    $avgLoss = array_sum($losses) / $period;
    if ($avgLoss == 0) return 100;
    $rs = $avgGain / $avgLoss;
    return 100 - (100 / (1 + $rs));
}

function calculateEMA($data, $period) {
    $ema = [];
    $k = 2 / ($period + 1);
    $ema[] = array_sum(array_slice($data, 0, $period)) / $period;
    for ($i = $period; $i < count($data); $i++) {
        $ema[] = $data[$i] * $k + end($ema) * (1 - $k);
    }
    return $ema;
}

function calculateMACD($prices, $fast = 12, $slow = 26, $signal = 9) {
    $emaFast = calculateEMA($prices, $fast);
    $emaSlow = calculateEMA($prices, $slow);
    $macdLine = [];
    $start = count($emaFast) - count($emaSlow); // align EMAs
    for ($i = 0; $i < count($emaSlow); $i++) {
        $macdLine[] = $emaFast[$i + $start] - $emaSlow[$i];
    }
    $signalLine = calculateEMA($macdLine, $signal);
    return [end($macdLine), end($signalLine)];
}

function getTopSymbolsByVolume($f = 0, $limit = 20) {
   // $url = "https://api.binance.com/api/v3/ticker/24hr";
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    $filtered = array_filter($data, fn($d) => str_ends_with($d['symbol'], 'USDT') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN'));
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

function analyzeSymbol($symbol) {
    $klines = getKlines($symbol, '1h', 100);
    if (!$klines || count($klines) < 60) return false;

    $closes = array_map(fn($k) => floatval($k[4]), $klines);
    $price = end($closes);

    $sma50 = calculateSMA($closes, 50);
    $rsi = calculateRSI(array_slice($closes, -15), 14);
    [$macd, $signal] = calculateMACD($closes);

    $isLong = $price > end($sma50) && $rsi > 50 && $rsi < 70 && $macd > $signal;
   // $isLong = $price > end($sma50) && $rsi < 30 && $macd > $signal;

    if ($isLong && $price < 1) {
        return [
            'symbol' => $symbol,
            'price' => $price,
            'rsi' => round($rsi, 2),
            'macd' => round($macd, 4),
            'macd_signal' => round($signal, 4),
            'take_profit' => calculateDynamicLongTP($price, $klines),   // +3%
            'stop_loss' => calculateDynamicLongSL($price, $klines),    // -1.5%
        ];
    }

    return false;
}

// MAIN
$topSymbols = getTopSymbolsByVolume(0, 20);
$topSymbols[] = 'CLRUSDT';
$topSymbols[] = 'GASUSDT';
if (($key = array_search('USDCUSDT', $topSymbols)) !== false) {
    unset($topSymbols[$key]);
}
if (($key = array_search('FDUSDUSDT', $topSymbols)) !== false) {
    unset($topSymbols[$key]);
}

$signals = [];
foreach ($topSymbols as $symbol) {
    $result = analyzeSymbol($symbol);
    if ($result) {
        $signals[] = $result;
    }
    if (count($signals) >= 1) break;
}

// === HELPER FUNCTION ===
function signedRequest($method, $endpoint, $params = [], $apiKey, $apiSecret)
{
    $timestamp = round(microtime(true) * 1000);
    $params['timestamp'] = $timestamp;

    $query = http_build_query($params, '', '&');
    $signature = hash_hmac('sha256', $query, $apiSecret);
    $query .= "&signature=" . $signature;

    $url = "https://fapi.binance.com" . $endpoint . "?" . $query;

    $headers = [
        "X-MBX-APIKEY: $apiKey"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new Exception('Curl error: ' . curl_error($ch));
    }
    curl_close($ch);

    return json_decode($response, true);
}



function getSymbolPrecision($symbol, $type) {
    
    $con = mysqli_connect("localhost", "easywayh_ekart", "easywayh_ekart", "easywayh_ekart");
    
    $sql = 'SELECT * FROM future_coin where symbol = "'.$symbol.'"';
    $result = mysqli_query($con, $sql);
    $row   = mysqli_fetch_assoc($result);
    
    if(!empty($row) && $type=='price_filter'){
        $size = $row['price_filter'];
        return $size;
       
    }elseif(!empty($row) && $type=='lot_size'){
       $size = $row['lot_size'];   
       return $size;
    }
   

   return false; 
}

function calculateLongOrderQuantity($availableMargin, $leverage, $entryPrice) {
    return ($availableMargin * $leverage) / $entryPrice;
}

function formatQuantity($quantity, $stepSize) {
    $precision = strlen(substr(strrchr(rtrim($stepSize, '0'), "."), 1));
    return number_format($quantity, $precision, '.', '');
}

$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY'; 
$apiToken2 ='8154971158:AAFhEKfOrzg3O4EZSeRTqWQAluRwug9nEs0'; 

// === CONFIG ===
$apiKey = 'bg_9d94f479477a882e0c5d18a538a51774';
$secretKey = 'ab6801c84bff147fecba6e2118d9d3dc17d32c4fd7e1a9f8d44404002ee9582b';
$passphrase = 'Welcome123';
$marginCoin = 'USDT';
if($st_time_1 < $cur_time && $end_time_1 > $cur_time){
    $leverage = 10;
    $availableMargin = 1;
}else{
    $leverage = 10;
    $availableMargin = 1;
}

// === COMMON FUNCTION ===
function sendBitgetRequest($method, $endpoint, $body, $apiKey, $secretKey, $passphrase) {
    $baseUrl = 'https://api.bitget.com';
    $timestamp = round(microtime(true) * 1000);
    $url = $baseUrl . $endpoint;

    $bodyStr = $body ? json_encode($body, JSON_UNESCAPED_SLASHES) : '';
    if ($method === 'GET' && !empty($body)) {
        $query = http_build_query($body);
        $url .= '?' . $query;
        $preHash = $timestamp . $method . $endpoint . '?' . $query;
    } else {
        $preHash = $timestamp . $method . $endpoint . $bodyStr;
    }

    $sign = base64_encode(hash_hmac('sha256', $preHash, $secretKey, true));

    $headers = [
        'Content-Type: application/json',
        'ACCESS-KEY: ' . $apiKey,
        'ACCESS-SIGN: ' . $sign,
        'ACCESS-TIMESTAMP: ' . $timestamp,
        'ACCESS-PASSPHRASE: ' . $passphrase,
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $bodyStr);
    }

    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// OUTPUT
if (count($signals) === 0) {
    echo "❌ No Long Signals Found\n";
} else {
    echo "✅ Top 2 Long Signals:\n\n";
    foreach ($signals as $signal) {
        
       /* if($signal['symbol']=='USDCUSDT' || $signal['symbol']=='FDUSDUSDT' || $signal['symbol']=='BTCUSDT'){
            break;
        }*/
        
        $price_size = getSymbolPrecision($signal['symbol'], 'price_filter');
        
        if(empty($price_size)){
            break;
        }
        
        $step_size = getSymbolPrecision($signal['symbol'], 'lot_size');
        $entry = formatQuantity($signal['price'], $price_size);
        $tp = formatQuantity($signal['take_profit'], $price_size);
        $sl = formatQuantity($signal['stop_loss'], $price_size);
        $rawQuantity = calculateLongOrderQuantity($availableMargin, $leverage, $entry);
        $quantity = formatQuantity($rawQuantity, $step_size);
        
        echo "🔹 Symbol:       {$signal['symbol']}\n";
        echo "   Entry:        {$entry}\n";
        echo "   RSI:          {$signal['rsi']}\n";
        echo "   MACD:         {$signal['macd']} > {$signal['macd_signal']}\n";
        echo "🎯 Take Profit:  {$tp}\n";
        echo "🛑 Stop Loss:    {$sl}\n\n";
        
        $html = "{$signal['symbol']} - RSI {$signal['rsi']}% - MACD {$signal['macd']} > {$signal['macd_signal']} - Price: {$entry} - TP : {$tp} - SL : {$sl} - Long MACD RSI Soma \r\n";
        
        
        $data = [ 
            'chat_id' => '7964239235', 
            'text' => $html
        ]; 
         
        $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
        
      /*  $data2 = [ 
            'chat_id' => '7207940112', 
            'text' => $html
        ]; */
     
       // $response = file_get_contents('http://api.telegram.org/bot'.$apiToken2.'/sendMessage?' . http_build_query($data2) ); 
        
        $symbol = $signal['symbol'].'_UMCBL';
        
        // === STEP 1: Check Open Orders ===
        $openOrders = sendBitgetRequest('GET', '/api/mix/v1/order/current', [
            'symbol' => $symbol,
            'marginCoin' => $marginCoin
        ], $apiKey, $secretKey, $passphrase);
        
        if (!empty($openOrders['data']) && count($openOrders['data']) > 0) {
            echo "Open order(s) already exist for $symbol.\n";
        } else {
            echo "No open orders for $symbol. Placing new order...\n";
        
            // === STEP 2: Set Leverage ===
            $leverageRes = sendBitgetRequest('POST', '/api/mix/v1/account/setLeverage', [
                'symbol' => $symbol,
                'marginCoin' => $marginCoin,
                'leverage' => (string)$leverage,
                'holdSide' => 'long'
            ], $apiKey, $secretKey, $passphrase);
        
            echo "Set Leverage:\n" . json_encode($leverageRes, JSON_PRETTY_PRINT) . "\n";
        
            // === STEP 3: Create Order with Take Profit ===
            $orderRes = sendBitgetRequest('POST', '/api/mix/v1/order/placeOrder', [
                'symbol' => $symbol,
                'marginCoin' => $marginCoin,
                'side' => 'open_long',
                'orderType' => 'market',
            //    'price' => '60000',                // set desired price
                'size' => $quantity,                 // order amount
                'timeInForceValue' => 'normal',
                'presetTakeProfitPrice' => $tp // TP
                //'presetStopLossPrice' => $sl
            ], $apiKey, $secretKey, $passphrase);
        
            echo "Create Order:\n" . json_encode($orderRes, JSON_PRETTY_PRINT) . "\n";
        }
        
    }
}