<?php

// === CONFIG ===
$api_key     = 'YOUR_BINANCE_API_KEY';
$api_secret  = 'YOUR_BINANCE_SECRET';
$symbol      = '1000PEPEUSDT';
$leverage    = 20;
$base_qty    = 1;
$max_dca     = 3;
$tp_pct      = 0.6; // 0.6%
$dca_trigger = 0.5; // % move against entry
$atr_factor  = 1.2; // skip DCA if price moves more than 1.2 × ATR
$telegram_token = 'AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';
$telegram_chat_id = '7964239235';

// === API FUNCTION ===
function binanceRequest($method, $endpoint, $params = [], $signed = false) {
    global $api_key, $api_secret;
    $base = 'https://fapi.binance.com';
    $headers = ['X-MBX-APIKEY: ' . $api_key];
    if ($signed) {
        $params['timestamp'] = round(microtime(true) * 1000);
        $query = http_build_query($params);
        $params['signature'] = hash_hmac('sha256', $query, $api_secret);
    }
    $url = $base . $endpoint;
    if ($method === 'GET') $url .= '?' . http_build_query($params);
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_CUSTOMREQUEST => $method
    ]);
    if ($method === 'POST' || $method === 'DELETE') {
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    }
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

// === TELEGRAM ===
function telegramAlert($msg) {
    global $telegram_token, $telegram_chat_id;
    file_get_contents("https://api.telegram.org/bot$telegram_token/sendMessage?" . http_build_query([
        'chat_id' => $telegram_chat_id, 'text' => $msg
    ]));
}

// === GET SIGNAL WITH RSI/VOLUME FILTER ===
function getFilteredSignal($symbol) {
    $klines = binanceRequest('GET', '/fapi/v1/klines', [
        'symbol' => $symbol, 'interval' => '1m', 'limit' => 20
    ]);
    if (count($klines) < 20) return null;

    $prev = floatval($klines[18][4]);
    $last = floatval($klines[19][4]);
    $direction = ($last > $prev) ? 'LONG' : 'SHORT';

    // RSI (14)
    $gains = $losses = 0;
    for ($i = 1; $i <= 14; $i++) {
        $diff = floatval($klines[$i][4]) - floatval($klines[$i - 1][4]);
        if ($diff > 0) $gains += $diff;
        else $losses += abs($diff);
    }
    $rsi = $losses == 0 ? 100 : 100 - (100 / (1 + ($gains / $losses)));

    if (($direction == 'LONG' && $rsi > 35) || ($direction == 'SHORT' && $rsi < 65)) return null;

    // Volume filter
    $vol = floatval($klines[19][5]);
    $avg_vol = array_sum(array_map(fn($k) => floatval($k[5]), array_slice($klines, 0, 14))) / 14;
    if ($vol < $avg_vol) return null;

    return $direction;
}

// === ATR CALCULATION (14-period) ===
function getATR($symbol, $period = 14) {
    $klines = binanceRequest('GET', '/fapi/v1/klines', [
        'symbol' => $symbol, 'interval' => '1m', 'limit' => $period + 1
    ]);
    if (count($klines) < $period + 1) return 0;

    $trs = [];
    for ($i = 1; $i <= $period; $i++) {
        $high = floatval($klines[$i][2]);
        $low = floatval($klines[$i][3]);
        $prev_close = floatval($klines[$i - 1][4]);
        $tr = max($high - $low, abs($high - $prev_close), abs($low - $prev_close));
        $trs[] = $tr;
    }
    return array_sum($trs) / count($trs);
}

// === GET POSITION ===
function getPosition($symbol) {
    $positions = binanceRequest('GET', '/fapi/v2/positionRisk', [], true);
    foreach ($positions as $p) {
        if ($p['symbol'] === $symbol && abs(floatval($p['positionAmt'])) > 0) return $p;
    }
    return null;
}

// === MAIN EXECUTION ===
$signal = getFilteredSignal($symbol);
if (!$signal) exit("❌ No valid signal (filters rejected)\n");

$side = $signal == 'LONG' ? 'BUY' : 'SELL';
$closeSide = $signal == 'LONG' ? 'SELL' : 'BUY';

$priceData = binanceRequest('GET', '/fapi/v1/ticker/price', ['symbol' => $symbol]);
$currentPrice = floatval($priceData['price']);

// Set leverage
/*binanceRequest('POST', '/fapi/v1/leverage', [
    'symbol' => $symbol, 'leverage' => $leverage
], true);*/

$atr = getATR($symbol);
$position = getPosition($symbol);

if (!$position) {
    // New entry
   /* $order = binanceRequest('POST', '/fapi/v1/order', [
        'symbol' => $symbol, 'side' => $side, 'type' => 'MARKET', 'quantity' => $base_qty
    ], true);*/
    telegramAlert("🚀 New $signal Entry at $currentPrice | ATR: $atr");
} else {
    $entry = floatval($position['entryPrice']);
    $amt = abs(floatval($position['positionAmt']));
    $dca_count = floor($amt / $base_qty);

    $price_diff = abs($currentPrice - $entry);
    if ($dca_count < $max_dca && $price_diff <= $atr * $atr_factor) {
        $triggerPrice = $signal === 'LONG'
            ? $entry * (1 - $dca_trigger / 100)
            : $entry * (1 + $dca_trigger / 100);

        $should_dca = ($signal === 'LONG' && $currentPrice <= $triggerPrice) ||
                      ($signal === 'SHORT' && $currentPrice >= $triggerPrice);

        if ($should_dca) {
           /* $order = binanceRequest('POST', '/fapi/v1/order', [
                'symbol' => $symbol, 'side' => $side, 'type' => 'MARKET', 'quantity' => $base_qty
            ], true);*/
            telegramAlert("🔁 DCA #".($dca_count + 1)." at $currentPrice (ATR=$atr)");
        }
    } else {
        telegramAlert("⚠️ DCA skipped due to volatility: diff=$price_diff > ATR×$atr_factor");
    }

    // TP Handling
    /*$tp_price = $signal === 'LONG'
        ? $entry * (1 + $tp_pct / 100)
        : $entry * (1 - $tp_pct / 100);

    $openOrders = binanceRequest('GET', '/fapi/v1/openOrders', ['symbol' => $symbol], true);
    foreach ($openOrders as $o) {
        if ($o['type'] === 'TAKE_PROFIT_MARKET') {
            binanceRequest('DELETE', '/fapi/v1/order', [
                'symbol' => $symbol, 'orderId' => $o['orderId']
            ], true);
        }
    }

    binanceRequest('POST', '/fapi/v1/order', [
        'symbol' => $symbol,
        'side' => $closeSide,
        'type' => 'TAKE_PROFIT_MARKET',
        'stopPrice' => number_format($tp_price, 2, '.', ''),
        'closePosition' => 'true',
        'timeInForce' => 'GTE_GTC'
    ], true);*/
    telegramAlert("🎯 TP set at $tp_price");
}
