<?php

function sendTelegramAlert($message) {
    $token = '7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';
    $chat_id = '7964239235';

    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function getHistoricalData($symbol, $interval = '1m', $limit = 1000) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result, true);
}

function calculateATR($data, $period = 14) {
    $atr = [];
    for ($i = $period; $i < count($data); $i++) {
        $trList = [];
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $high = $data[$j][2];
            $low = $data[$j][3];
            $prevClose = $data[$j - 1][4];
            $tr = max($high - $low, abs($high - $prevClose), abs($low - $prevClose));
            $trList[] = $tr;
        }
        $atr[] = array_sum($trList) / $period;
    }
    return $atr;
}

function calculateAvgVolume($volumes, $period = 20) {
    $avgVol = [];
    for ($i = $period; $i < count($volumes); $i++) {
        $avg = array_sum(array_slice($volumes, $i - $period, $period)) / $period;
        $avgVol[] = $avg;
    }
    return $avgVol;
}

// Parameters
$tp_multiplier = 1.5;
$sl_multiplier = 1.0;



function getTopSymbolsByVolume($f = 0, $limit = 20) {
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    
  //  print_r($data);
    
    $filtered = array_filter($data, function($d) {
        return str_ends_with($d['symbol'], 'USDT') &&
               floatval($d['lastPrice']) < 1;
    });
    
    $filtered = array_reverse($filtered);
    
    
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

$topSymbols = getTopSymbolsByVolume(0, 20); //print_r($topSymbols);

foreach ($topSymbols as $symbol) {
//    echo "Backtesting $symbol...<br>";

    $data = getHistoricalData($symbol, '5m', 500);
    if (!$data || count($data) < 100) {
        echo "Not enough data for $symbol.\n";
        continue;
    }

    $closes = array_column($data, 4);
    $highs = array_column($data, 2);
    $lows = array_column($data, 3);
    $volumes = array_column($data, 5);

    $atr = calculateATR($data);
    $avgVol = calculateAvgVolume($volumes);

    $offset = max(count($atr), count($avgVol));
    $balance = 1000;
    $position = 0;
    $entry_price = 0;
    $returns = [];

    for ($i = $offset; $i < count($closes) - 1; $i++) {
        $price = $closes[$i + 1];
        $prev_close = $closes[$i];
        $move = $price - $prev_close;

        $atr_val = $atr[$i - count($closes) + count($atr)];
        $vol = $volumes[$i];
        $vol_avg = $avgVol[$i - count($closes) + count($avgVol)];

        if ($position === 0 && $move > 0.5 * $atr_val && $vol > $vol_avg) {
            $entry_price = $price;
            $tp_price = $entry_price + ($tp_multiplier * $atr_val);
            $sl_price = $entry_price - ($sl_multiplier * $atr_val);
            $position = 1;
        }

        if ($position === 1) {
            if ($price >= $tp_price) {
                $profit = ($tp_price - $entry_price) / $entry_price;
                $returns[] = $profit;
                $position = 0;
            } elseif ($price <= $sl_price) {
                $loss = ($sl_price - $entry_price) / $entry_price;
                $returns[] = $loss;
                $position = 0;
            }
        }
    }

    
    if ($position === 0 && $move > 0.5 * $atr_val && $vol > $vol_avg) {
        $entry_price = $price;
        $tp_price = $entry_price + ($tp_multiplier * $atr_val);
        $sl_price = $entry_price - ($sl_multiplier * $atr_val);
        $position = 1;
    
        // Calculate win rate so far
        $trades = count($returns);
        $wins = count(array_filter($returns, fn($x) => $x > 0));
        $win_rate = $trades > 0 ? round($wins / $trades * 100, 2) : 0;
    
        $tradingview_url = "https://www.tradingview.com/chart/?symbol=BINANCE:$symbol";

        $message = "🚀 *Perfect Long Signal Detected!*\n"
             . "Symbol: `$symbol`\n"
             . "Entry: `$entry_price`\n"
             . "TP: `$tp_price`\n"
             . "SL: `$sl_price`\n"
             . "📈 Win Rate: *$win_rate%*\n"
             . "📊 [View Chart]($tradingview_url)\n"
             . "🕒 Time: `" . date('Y-m-d H:i:s') . "`";
        echo $message;     
        sendTelegramAlert($message);
    }
}