<?php


function getSymbolPrecision($symbol, $type) {
    
    $con = mysqli_connect("localhost", "easywayh_ekart", "easywayh_ekart", "easywayh_ekart");
    
    $sql = 'SELECT * FROM future_coin where symbol = "'.$symbol.'"';
    $result = mysqli_query($con, $sql);
    $row   = mysqli_fetch_assoc($result);
    
    if(!empty($row) && $type=='price_filter'){
        $size = $row['price_filter'];
        return $size;
       
    }elseif(!empty($row) && $type=='lot_size'){
       $size = $row['lot_size'];   
       return $size;
    }
   

   return false; 
}

function calculateLongOrderQuantity($availableMargin, $leverage, $entryPrice) {
    return ($availableMargin * $leverage) / $entryPrice;
}

function formatQuantity($quantity, $stepSize) {
    $precision = strlen(substr(strrchr(rtrim($stepSize, '0'), "."), 1));
    return number_format($quantity, $precision, '.', '');
}

// --------------------- LOCK FILE TO PREVENT DUPLICATES ---------------------
$lockFile = '/tmp/binance_signal_bot.lock';
if (file_exists($lockFile) && (time() - filemtime($lockFile) < 3500)) exit;
touch($lockFile);
register_shutdown_function(function() use ($lockFile) {
    if (file_exists($lockFile)) unlink($lockFile);
});

// --------------------- TELEGRAM CONFIG ---------------------
function sendTelegramAlert($message) {
    $token = '7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY';
    $chat_id = '7964239235';

    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $data = ['chat_id' => $chat_id, 'text' => $message, 'parse_mode' => 'Markdown'];
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_RETURNTRANSFER => true
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// --------------------- FETCH HISTORICAL DATA ---------------------
function getHistoricalData($symbol, $interval = '1h', $limit = 100) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER => 1]);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result, true);
}

// --------------------- INDICATOR CALCULATIONS ---------------------
function calculateATR($data, $period = 14) {
    $atr = [];
    for ($i = $period; $i < count($data); $i++) {
        $trSum = 0;
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $high = $data[$j][2];
            $low = $data[$j][3];
            $prevClose = $data[$j - 1][4];
            $tr = max($high - $low, abs($high - $prevClose), abs($low - $prevClose));
            $trSum += $tr;
        }
        $atr[] = $trSum / $period;
    }
    return $atr;
}

function calculateAvgVolume($volumes, $period = 20) {
    $avgVol = [];
    for ($i = $period; $i < count($volumes); $i++) {
        $avg = array_sum(array_slice($volumes, $i - $period, $period)) / $period;
        $avgVol[] = $avg;
    }
    return $avgVol;
}

// --------------------- MAIN PARAMETERS ---------------------
$tp_multiplier = 2.0;
$sl_multiplier = 1.0;

function getTopSymbolsByVolume($f = 0, $limit = 20) {
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    
  //  print_r($data);
    
    $filtered = array_filter($data, function($d) {
        return str_ends_with($d['symbol'], 'USDT') &&
               floatval($d['lastPrice']) < 1;
    });
    
    $filtered = array_reverse($filtered);
    
    
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}

$symbols = getTopSymbolsByVolume(0, 20); // print_r($symbols);

// === CONFIG ===
$apiKey = "tLIUULmMtdjq58tteHtFCdZqtpleEPGUQn85Y0qn39PaF7dpM75PGFWmMeXJloPf";
$apiSecret = "NZNQwTSfuTv07Qp1cFJ6mpVU2qpMrNJGsL24o2lRSXuNTlnmnSBCubuxo1gqtogG";

$availableMargin = 1;

$i=0;

foreach ($symbols as $symbol) {
    echo "Backtesting $symbol...\n";

    $data = getHistoricalData($symbol, '1h', 150);
    if (!$data || count($data) < 50) {
        echo "Not enough data for $symbol.\n";
        continue;
    }

    $closes = array_column($data, 4);
    $volumes = array_column($data, 5);
    $atr = calculateATR($data);
    $avgVol = calculateAvgVolume($volumes);

    $offset = max(count($atr), count($avgVol));
    $position = 0;
    $entry_price = 0;
    $returns = [];

    for ($i = $offset; $i < count($closes) - 1; $i++) {
        $price = $closes[$i + 1];
        $prev_close = $closes[$i];
        $move = $price - $prev_close;

        $atr_val = $atr[$i - count($closes) + count($atr)];
        $vol = $volumes[$i];
        $vol_avg = $avgVol[$i - count($closes) + count($avgVol)];

        // ENTRY
        if ($position === 0 && $move > 0.5 * $atr_val && $vol > $vol_avg) {
            $entry_price = $price;
            $tp_price = $entry_price + ($tp_multiplier * $atr_val);
            $sl_price = $entry_price - ($sl_multiplier * $atr_val);
            $position = 1;

            $trades = count($returns);
            $wins = count(array_filter($returns, fn($x) => $x > 0));
            $win_rate = $trades > 0 ? round($wins / $trades * 100, 2) : 0;

            if($win_rate == 100){ 
                
                $i++;
                
                $price_size = getSymbolPrecision($symbol, 'price_filter');
                $step_size = getSymbolPrecision($symbol, 'lot_size');
                
                $entry_price = formatQuantity($entry_price, $price_size);
                $tp_price = formatQuantity($tp_price, $price_size);
                $sl_price = formatQuantity($sl_price, $price_size);
                
                $params = ["symbol" => $symbol]; // USDT-M pair
    
                $response = signedRequest("GET", "/fapi/v2/positionRisk", $params, $apiKey, $apiSecret);
                
                // Check liquidation status logic
                if($i==1){
                    if (!empty($response) && is_array($response)) {
                        $position = $response[0];
                        $positionAmt = floatval($position['positionAmt']);
                    
                        if ($positionAmt == 0) {
                            
                            $leverageParams = [
                                "symbol" => $symbol,
                                "leverage" => 30
                            ];
                            $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                            $leverage = 30;
                            if(!empty($setLeverage['code'])){
                                $leverageParams = [
                                    "symbol" => $symbol,
                                    "leverage" => 20
                                ];
                                $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                                $leverage = 20;
                                    if(!empty($setLeverage['code'])){
                                        $leverageParams = [
                                        "symbol" => $symbol,
                                        "leverage" => 15
                                    ];
                                    $setLeverage = signedRequest("POST", "/fapi/v1/leverage", $leverageParams, $apiKey, $apiSecret);
                                    $leverage = 15;
                                }
                            }
                
                            
                                
                                
                                $rawQuantity = calculateLongOrderQuantity($availableMargin, $leverage, $entry_price);
                                $quantity = formatQuantity($rawQuantity, $step_size);
                                
                                $orderParams = [
                                    "symbol" => $symbol,
                                    "side" => "BUY",             // LONG
                                    "type" => "MARKET",
                                    "quantity" => $quantity          // Adjust for your budget
                                ];
                                $marketOrder = signedRequest("POST", "/fapi/v1/order", $orderParams, $apiKey, $apiSecret);
                                
                                // === 3. SET TAKE PROFIT (SELL) ORDER ===
                                if (!empty($marketOrder['orderId'])) {
                                    $tpParams = [
                                        "symbol" => $symbol,
                                        "side" => 'SELL',
                                        "type" => "TAKE_PROFIT_MARKET",
                                        "stopPrice" => $tp_price,
                                        "quantity" => $quantity,
                                        "timeInForce" => "GTC",
                                        "reduceOnly" => "true",
                                        "timestamp" => round(microtime(true) * 1000)
                                    ];
                                    $tpOrder = signedRequest("POST", "/fapi/v1/order", $tpParams, $apiKey, $apiSecret);
                                    
                                   
                                
                                }
                                
                            
                            
                            }
                        }
                    }

                $tv_url = "https://www.tradingview.com/chart/?symbol=BINANCE:$symbol";
                $message = "🚀 *Perfect Long Signal Detected!*\n"
                         . "Symbol: `$symbol`\n"
                         . "Entry: `$entry_price`\n"
                         . "TP: `$tp_price`\n"
                         . "SL: `$sl_price`\n"
                         . "📈 Win Rate: *$win_rate%*\n"
                         . "📊 [View Chart]($tv_url)\n"
                         . "🕒 Time: `" . date('Y-m-d H:i:s') . "`";
                sendTelegramAlert($message);
                
                
            }
        }

        // EXIT
        if ($position === 1) {
            if ($price >= $tp_price) {
                $returns[] = ($tp_price - $entry_price) / $entry_price;
                $position = 0;
            } elseif ($price <= $sl_price) {
                $returns[] = ($sl_price - $entry_price) / $entry_price;
                $position = 0;
            }
        }
    }

    echo "$symbol: Trades = " . count($returns) . " | Win Rate = " . (count($returns) ? round(count(array_filter($returns, fn($x) => $x > 0)) / count($returns) * 100, 2) : 0) . "%<br>";
}