<?php
ini_set( 'display_errors', 1 );
$con = mysqli_connect("localhost", "easywayh_ekart", "easywayh_ekart", "easywayh_ekart");

$res = mysqli_query($con, "SELECT * FROM future_coin where bullish_cross = 'Y'");
$symbols = array();
while ($row = $res->fetch_assoc()) { 
  $code = $row['symbol'];
  $symbols[] = $code;
  
}


$interval = "1h";
$limit = 100;

function getKlines($symbol, $interval = '1h', $limit = 100) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

// Helper: EMA
function calculateEMA($data, $period) {
    $ema = [];
    $k = 2 / ($period + 1);
    $ema[] = array_sum(array_slice($data, 0, $period)) / $period;
    for ($i = $period; $i < count($data); $i++) {
        $ema[] = $data[$i] * $k + end($ema) * (1 - $k);
    }
    return $ema;
}

function calculateMACD($prices, $fast = 12, $slow = 26, $signal = 9) {
    $emaFast = calculateEMA($prices, $fast);
    $emaSlow = calculateEMA($prices, $slow);
    $macdLine = [];
    $start = count($emaFast) - count($emaSlow); // align EMAs
    for ($i = 0; $i < count($emaSlow); $i++) {
        $macdLine[] = $emaFast[$i + $start] - $emaSlow[$i];
    }
    $signalLine = calculateEMA($macdLine, $signal);
    return [end($macdLine), end($signalLine)];
}

function calculateDynamicLongTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Get highs from klines
    $highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high price
    
    $highestHigh = max($highs);

    // Subtract a small buffer to improve fill rate
    $takeProfit = $highestHigh - ($highestHigh * $bufferPercent / 100);

    // Ensure TP is above entry
    return ($takeProfit > $entryPrice) ? round($takeProfit, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback to +1%
}

function calculateDynamicLongSL($entryPrice, $klines, $bufferPercent = 0.0985) {
    if (empty($klines)) return null;

    // Get the lowest "low" from all candles
    $lows = array_map(fn($k) => floatval($k[3]), $klines); // index 3 = low price
    $lowestLow = min($lows);

    // Subtract a buffer to give some room
    $stopLoss = $lowestLow - ($lowestLow * $bufferPercent / 100);

    // Make sure SL is below entry
    return ($stopLoss < $entryPrice) ? round($stopLoss, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% below entry
}
function calculateTakeProfit(float $entryPrice, float $tpPercent = 3.0): float {
    return $entryPrice * (1 + $tpPercent / 100);
}

$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY'; 

//print_r($symbols);
foreach ($symbols as $symbol) {
    
    $macd_cross = 'N';
    
    $klines = getKlines($symbol, '1h', 100);
    if ($klines || count($klines) > 60){
        
        $closes = array_map(fn($k) => floatval($k[4]), $klines);
        $price = end($closes);
        
        [$macd, $signal] = calculateMACD($closes);
        
        if($macd > $signal){
            
            $take_profit = calculateDynamicLongTP($price, $data);
            $take_profit_1 = calculateTakeProfit($price, 1.5);
            $stop_loss = calculateDynamicLongSL($price, $data);
            
            $html = "{$symbol} - Price: {$price} - TP : {$take_profit} - TP 1 : {$take_profit_1}- SL : {$stop_loss} - Long MACD Cross \r\n";
            $data = [ 
                'chat_id' => '7964239235', 
                'text' => $html
            ]; 
             
            $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
        
            $macd_cross = 'Y';
        
        }
    }
    
    $sql = 'UPDATE future_coin SET macd_cross = "'.$macd_cross.'" WHERE symbol ="'.$symbol.'"';
    mysqli_query($con, $sql);
    
}