<?php
ini_set( 'display_errors', 1 );


$apiKey = "tLIUULmMtdjq58tteHtFCdZqtpleEPGUQn85Y0qn39PaF7dpM75PGFWmMeXJloPf";
$apiSecret = "NZNQwTSfuTv07Qp1cFJ6mpVU2qpMrNJGsL24o2lRSXuNTlnmnSBCubuxo1gqtogG";

function getFuturesSymbols($f = 0, $limit = 20) {
    $url = 'https://fapi.binance.com/fapi/v1/ticker/price';
    $data = json_decode(file_get_contents($url), true);
    $symbols = [];

    foreach ($data as $item) {
        if (str_ends_with($item['symbol'], 'USDT') && $item['price'] < 1 ) {
            $symbols[] = $item['symbol'];
        }
    }
    $symbols = array_slice($symbols, $f, $limit);
    return $symbols;
}

// === Entry Point ===
$symbols = getFuturesSymbols(0, 20); 
foreach ($symbols as $symbol) {
$result = detectMultiTFStrongShortSignal($symbols, $apiKey, $apiSecret);
    if ($result) {
        $msg = " <b>Multi-TF SHORT Signal</b> for {$result['symbol']}\n" .
               " Entry: {$result['entry']}\n🎯 TP: {$result['tp']}  🛑 SL: {$result['sl']}\n" .
               " RSI 5m/15m/1h: " . implode('/', $result['rsi']) . "\n" .
               " MACD < Signal on all timeframes";
        sendTelegramAlert($msg);
    }
}

// === Core Signal Detection ===
function detectMultiTFStrongShortSignal($symbol, $apiKey, $apiSecret) {
    $tfList = ['5m', '15m', '1h'];
    $data = [];

    foreach ($tfList as $tf) {
        $klines = getKlines($symbol, $tf, 100, $apiKey, $apiSecret);
        if (!$klines || count($klines) < 35) return null;

        $closes = array_column($klines, 4);
        $highs = array_column($klines, 2);
        $lows  = array_column($klines, 3);

        $rsi = calculateRSI($closes);
        [$macd, $signal] = calculateMACD($closes);
        $engulfing = detectBearishEngulfing($klines);
        $atr = calculateATR($highs, $lows, $closes);

        $data[$tf] = [
            'rsi' => $rsi,
            'macd' => $macd,
            'signal' => $signal,
            'engulfing' => $engulfing,
            'price' => floatval(end($closes)),
            'atr' => $atr,
        ];
    }

    $tf5 = $data['5m'];
    $tf15 = $data['15m'];
    $tf1h = $data['1h'];

    $rsiCheck = $tf5['rsi'] > 65 && $tf15['rsi'] > 60 && $tf1h['rsi'] > 55;
    $macdCheck = $tf5['macd'] < $tf5['signal'] && $tf15['macd'] < $tf15['signal'] && $tf1h['macd'] < $tf1h['signal'];
    $engulfingCheck = $tf5['engulfing'] || $tf15['engulfing'];

    if ($rsiCheck && $macdCheck && $engulfingCheck) {
        $entry = $tf5['price'];
        $atr = $tf5['atr'];
        $tp = round($entry - 2 * $atr, 4);
        $sl = round($entry + 1.2 * $atr, 4);

        return [
            'symbol' => $symbol,
            'entry' => $entry,
            'tp' => $tp,
            'sl' => $sl,
            'rsi' => ['5m' => $tf5['rsi'], '15m' => $tf15['rsi'], '1h' => $tf1h['rsi']],
            'macd' => ['5m' => $tf5['macd'], '15m' => $tf15['macd'], '1h' => $tf1h['macd']],
            'signal' => ['5m' => $tf5['signal'], '15m' => $tf15['signal'], '1h' => $tf1h['signal']],
        ];
    }

    return null;
}

// === Indicator Calculations ===
function calculateRSI($closes, $period = 14) {
    $gains = $losses = [];
    for ($i = 1; $i <= $period; $i++) {
        $diff = $closes[$i] - $closes[$i - 1];
        $gains[] = $diff > 0 ? $diff : 0;
        $losses[] = $diff < 0 ? abs($diff) : 0;
    }

    $avgGain = array_sum($gains) / $period;
    $avgLoss = array_sum($losses) / $period;

    if ($avgLoss == 0) return 100;
    $rs = $avgGain / $avgLoss;
    return 100 - (100 / (1 + $rs));
}

function calculateMACD($closes, $fast = 12, $slow = 26, $signalPeriod = 9) {
    $emaFast = calculateEMA($closes, $fast);
    $emaSlow = calculateEMA($closes, $slow);
    $macdLine = [];
    for ($i = 0; $i < count($emaSlow); $i++) {
        $macdLine[] = $emaFast[$i + ($slow - $fast)] - $emaSlow[$i];
    }
    $signalLine = calculateEMA($macdLine, $signalPeriod);
    return [end($macdLine), end($signalLine)];
}

function calculateEMA($prices, $period) {
    $k = 2 / ($period + 1);
    $ema = [array_sum(array_slice($prices, 0, $period)) / $period];
    for ($i = $period; $i < count($prices); $i++) {
        $ema[] = $prices[$i] * $k + end($ema) * (1 - $k);
    }
    return $ema;
}

function calculateATR($highs, $lows, $closes, $period = 14) {
    $trs = [];
    for ($i = 1; $i < count($highs); $i++) {
        $tr = max(
            $highs[$i] - $lows[$i],
            abs($highs[$i] - $closes[$i - 1]),
            abs($lows[$i] - $closes[$i - 1])
        );
        $trs[] = $tr;
    }
    return array_sum(array_slice($trs, -$period)) / $period;
}

function detectBearishEngulfing(array $klines) {
    $n = count($klines);
    if ($n < 2) return false;

    $prev = $klines[$n - 2];
    $curr = $klines[$n - 1];

    $o1 = floatval($prev[1]);
    $c1 = floatval($prev[4]);
    $o2 = floatval($curr[1]);
    $c2 = floatval($curr[4]);

    return ($c1 > $o1) && ($c2 < $o2) && ($o2 > $c1) && ($c2 < $o1);
}

function getKlines($symbol, $interval, $limit, $apiKey, $apiSecret) {
    $base = "https://fapi.binance.com/fapi/v1/klines";
    $query = http_build_query([
        'symbol' => $symbol,
        'interval' => $interval,
        'limit' => $limit
    ]);

    $ch = curl_init("{$base}?{$query}");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);

    return json_decode($res, true);
}

function sendTelegramAlert($msg) {
    $botToken = "7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY";
    $chatId = "7964239235";
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $params = [
        'chat_id' => $chatId,
        'text' => $msg,
        'parse_mode' => 'HTML'
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}