<?php
//ini_set( 'display_errors', 1 );

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once "config.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

function getHotUsdtCoins($limit = 5, $minVolume = 1000) {
     // Step 1: Get Futures exchange info
    $exchangeInfoUrl = "https://fapi.binance.com/fapi/v1/exchangeInfo";
    $exchangeJson = file_get_contents($exchangeInfoUrl);
    $exchangeData = json_decode($exchangeJson, true);

    // Get valid USDT-margined futures symbols
    $usdtSymbols = [];
    foreach ($exchangeData['symbols'] as $symbolInfo) {
        if (
            $symbolInfo['status'] === 'TRADING' &&
            $symbolInfo['quoteAsset'] === 'USDT'
        ) {
            $usdtSymbols[] = $symbolInfo['symbol'];
        }
    }

    // Step 2: Get 24h ticker price change stats
    $tickerUrl = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $tickerJson = file_get_contents($tickerUrl);
    $tickerData = json_decode($tickerJson, true);

    // Step 3: Filter only USDT futures symbols
    $hotCoins = array_filter($tickerData, function ($coin) use ($usdtSymbols, $minVolume) {
        return in_array($coin['symbol'], $usdtSymbols) &&
               floatval($coin['quoteVolume']) > $minVolume;
    });

    // Step 4: Sort by 24h price change percent (desc)
    usort($hotCoins, function ($a, $b) {
        return floatval($b['priceChangePercent']) <=> floatval($a['priceChangePercent']);
    });

    // Return top N
    return array_slice($hotCoins, 0, $limit);
}

function getFuturesKlines($symbol = 'BTCUSDT', $interval = '1h', $limit = 20) {
    /*$url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $json = file_get_contents($url);
    return json_decode($json, true);*/
    
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";  // limit 100 for the last 100 candles

    // Use cURL to fetch data from the API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the JSON response
    return json_decode($response, true);
}

function calculateSMA($data, $period) {
    $sma = []; //echo count($data) - $period;
    for ($i = 0; $i <= count($data) - $period; $i++) {
        $sum = 0;
        for ($j = $i; $j < $i + $period; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function checkShortSignal($symbol = 'BTCUSDT') {
    $klines = getFuturesKlines($symbol);
    
    $closingPrices = array_map(function($kline) {
        return floatval($kline[4]); // Closing price
    }, $klines);
  //  echo $symbol;
  //  print_r($closingPrices);


    $sma50 = calculateSMA($closingPrices, 5);
    $sma200 = calculateSMA($closingPrices, 20);

    $latestPrice = end($closingPrices);
    $latestSMA50 = end($sma50);
    $latestSMA200 = end($sma200);

 //   echo $latestPrice.' - '.$latestSMA50.' - '.$latestSMA200;

    if ($latestPrice < $latestSMA50 && $sma50[count($sma50)-2] > $sma200[count($sma200)-2] && $latestSMA50 < $latestSMA200) {
        return true;
    } else { 
        return false;
    }
}

function calculateDynamicShortSL($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Extract highs from candles
    //$highs = array_map(fn($k) => floatval($k[2]), $klines); // index 2 = high
    $highs = array_map(function($k) {
        return floatval($k[3]); // Closing price
    }, $klines);
    $highestHigh = max($highs);

    // Add buffer (e.g., 0.3%) above resistance
    $stopLoss = $highestHigh + ($highestHigh * $bufferPercent / 100);

    // Make sure SL is above entry (as it's a short)
    return ($stopLoss > $entryPrice) ? round($stopLoss, 5) : round($entryPrice + ($entryPrice * 0.01), 5); // fallback 1% above
}

function calculateDynamicShortTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Extract lowest "low" from recent candles
    //$lows = array_map(function($k) => floatval($k[3]), $klines); // index 3 = low
    $lows = array_map(function($k) {
        return floatval($k[3]); // Closing price
    }, $klines);
    $lowestLow = min($lows);

    // Add small buffer (to increase TP hit rate)
    $takeProfit = $lowestLow + ($lowestLow * $bufferPercent / 100);

    // Ensure TP is below entry price
    return ($takeProfit < $entryPrice) ? round($takeProfit, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% lower
}

function checkPrice($symbol = 'BTCUSDT') {
    $klines = getFuturesKlines($symbol);
    
    $closingPrices = array_map(function($kline) {
        return floatval($kline[4]); // Closing price
    }, $klines);

    $sma50 = calculateSMA($closingPrices, 5);
    $sma200 = calculateSMA($closingPrices, 20);

    $latestPrice = end($closingPrices);
    $latestSMA50 = end($sma50);
    $latestSMA200 = end($sma200);
    
    $price = array(
            'latestPrice' => $latestPrice,
            'latestSMA50' => $latestSMA50,
            'latestSMA200' => $latestSMA200
        );
    
    return $price;
}

$mail = false;

$order_coincount = 0;
$sql="SELECT * FROM order_coin where status = 1";
if ($result=mysqli_query($con,$sql))
{
$order_coincount=mysqli_num_rows($result);
}
if($order_coincount < 5){
    $hotCoins = getHotUsdtCoins();
    $html = '';
    foreach ($hotCoins as $coin) {
        $coin_code = $coin['symbol'];
        
        $sql = 'SELECT * FROM order_coin where code = "'.$coin_code.'" AND status = 1';
        $result = mysqli_query($con, $sql);
        $row   = mysqli_fetch_assoc($result);  
        if(empty($row)){
        $check = checkShortSignal($coin_code);  
            if($check==true){
                $binance_order_id = uniqid();
                $klines = getFuturesKlines($coin_code, "1h", 20);
                $checkPrice = checkPrice($coin_code);
                $tp = calculateDynamicShortTP($checkPrice['latestPrice'], $klines, 0.3);
                $sl = calculateDynamicShortSL($checkPrice['latestPrice'], $klines, 0.3);
                $sql = "INSERT INTO order_coin (code, binance_order_id, bid_price, take_profit, stop_loss, type, order_latest_price, order_latestSMA50, order_latestSMA200, status) VALUES ('" . $coin_code . "', '" . $binance_order_id . "', '" . $checkPrice['latestPrice'] . "', '" . $tp . "', '" . $sl . "', 'S', '" . $checkPrice['latestPrice'] . "', '" . $checkPrice['latestSMA50'] . "', '" . $checkPrice['latestSMA200'] . "', 1)";
                mysqli_query($con, $sql);
                
                $html .= '<table>';
                $html .= '<tr><td rownpan="2">Live SHORT signal for '.$coin_code.'</td></tr>';
                $html .= '<tr><td>Type</td><td>Short</td></tr>';
                $html .= '<tr><td>Latest Price</td><td>'.$checkPrice['latestPrice'].'</td></tr>';
                $html .= '<tr><td>Latest Price 1</td><td>'.$checkPrice['latestSMA50'].'</td></tr>';
                $html .= '<tr><td>Latest Price 2</td><td>'.$checkPrice['latestSMA200'].'</td></tr>';
                $html .= '<tr><td>TPL</td><td>'.$tp.'</td></tr>';
                $html .= '<tr><td>SL</td><td>'.$sl.'</td></tr>';
                $html .= '</table>';
                $html .= '<br><br><br>';
                
                $mail = true;
            }
        }
        
    }
}else{
    
}


if(!empty($mail)){
    $mail = new PHPMailer;
    $mail->isSMTP(); 
    $mail->SMTPDebug = 0; // 0 = off (for production use) - 1 = client messages - 2 = client and server messages
    $mail->Host = "mail.easywayb.com"; // use $mail->Host = gethostbyname('smtp.gmail.com'); // if your network does not support SMTP over IPv6
    $mail->Port = 465; // TLS only
    $mail->SMTPSecure = 'ssl'; // ssl is depracated
    $mail->SMTPAuth = true;
    $mail->Username = 'binance@easywayb.com';
    $mail->Password = 'VignzC;&?i29';
    $mail->setFrom('binance@easywayb.com', 'binance');
    //$mail->addReplyTo('@gmail.com', ' Name');
    $mail->addAddress('info@easywayb.com', 'priyankar');
    $mail->Subject = 'Binance short signal';
    $mail->msgHTML($html); //$mail->msgHTML(file_get_contents('contents.html'), __DIR__); //Read an HTML message body from an external file, convert referenced images to embedded,
    //$mail->AltBody = 'HTML messaging not supported';
    // $mail->addAttachment('images/phpmailer_mini.png'); //Attach an image file
    
    if(!$mail->send()){
       // echo "Mailer Error: " . $mail->ErrorInfo;
    }else{
        //echo "Message sent!";
        echo $html;
        
    }
}