<?php

/**
 * Get recent klines for a given symbol and interval.
 */
function getBinanceKlines($symbol = "BTCUSDT", $interval = "15m", $limit = 20) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    curl_close($ch);

    $klines = json_decode($result, true);
    return is_array($klines) ? $klines : [];
}

/**
 * Calculate dynamic take-profit for short based on recent support level.
 *
 * @param float $entryPrice Entry price for the short.
 * @param array $klines Klines array from Binance.
 * @param float $bufferPercent Buffer above the lowest low (e.g., 0.3)
 * @return float Calculated take-profit price
 */
function calculateDynamicShortTP($entryPrice, $klines, $bufferPercent = 0.3) {
    if (empty($klines)) return null;

    // Extract lowest "low" from recent candles
    //$lows = array_map(function($k) => floatval($k[3]), $klines); // index 3 = low
    $lows = array_map(function($k) {
        return floatval($k[3]); // Closing price
    }, $klines);
    $lowestLow = min($lows);

    // Add small buffer (to increase TP hit rate)
    $takeProfit = $lowestLow + ($lowestLow * $bufferPercent / 100);

    // Ensure TP is below entry price
    return ($takeProfit < $entryPrice) ? round($takeProfit, 5) : round($entryPrice - ($entryPrice * 0.01), 5); // fallback 1% lower
}

// === USAGE EXAMPLE ===
$symbol = "ARKUSDT";
$entryPrice = 0.3859; // Example short entry

$klines = getBinanceKlines($symbol, "1h", 20);
$tp = calculateDynamicShortTP($entryPrice, $klines, 0.3);

if ($tp) {
    echo "Dynamic Take-Profit for SHORT $symbol: $" . $tp;
} else {
    echo "Failed to calculate TP.";
}