<?php
ini_set( 'display_errors', 1 );




function getJson(string $url): array {
    $json = file_get_contents($url);
    return json_decode($json, true);
}

function getFuturesSymbols(): array {
    $apiUrl = "https://fapi.binance.com/fapi/v1/exchangeInfo";
    $info = getJson($apiUrl);
   /* $symbols = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'USDT') && $s['contractType'] === 'PERPETUAL';
    });
    
    shuffle($symbols);
    return  (array_slice($symbols, 0 ,10));*/
    
    
    $symbols1 = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'DRIFTUSDT') && $s['contractType'] === 'PERPETUAL';
    });
    $symbols2 = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'BSWUSDT') && $s['contractType'] === 'PERPETUAL';
    });
    $symbols3 = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'VOXELUSDT') && $s['contractType'] === 'PERPETUAL';
    });
    $symbols4 = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'AIOTUSDT') && $s['contractType'] === 'PERPETUAL';
    });
    $symbols5 = array_filter($info['symbols'], function($s) {
        return str_ends_with($s['symbol'], 'CATIUSDT') && $s['contractType'] === 'PERPETUAL';
    });
    
    return array_merge($symbols1,$symbols2, $symbols3, $symbols4, $symbols5);

    
} 

function getCandles(string $symbol, string $interval = '1h', int $limit = 100): array {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    return getJson($url);
}

function calculateRSI(array $closes, int $period = 14): float {
    $gains = $losses = [];

    for ($i = 1, $len = count($closes); $i < $len; $i++) {
        $change = $closes[$i] - $closes[$i - 1];
        $gains[] = max(0, $change);
        $losses[] = max(0, -$change);
    }

    $avgGain = array_sum(array_slice($gains, -$period)) / $period;
    $avgLoss = array_sum(array_slice($losses, -$period)) / $period;

    if ($avgLoss == 0.0) return 100.0;

    $rs = $avgGain / $avgLoss;
    return 100.0 - (100.0 / (1.0 + $rs));
}

function calculateShortTP(float $entryPrice, float $tpPercent = 3.0): float {
    return $entryPrice * (1 - $tpPercent / 100);
}

//$symbols = getFuturesSymbols(); print_r($symbols);

function analyzeShortSignals(): array {
    $symbols = getFuturesSymbols();
    
    $shortSignals = [];

    foreach ($symbols as $s) {
        $symbol = $s['symbol'];
        $candles = getCandles($symbol);

        if (count($candles) < 100) continue;

      //  $closes = array_map(fn($c) => (float)$c[4], $candles);
        $closes = array_map(function($c) {
        return floatval($c[4]); // Closing price
    }, $candles); 
        $rsi = calculateRSI($closes);
        $entry = $closes[array_key_last($closes)];
        $prev = $closes[array_key_last($closes) - 1];
        $change1h = ($entry - $prev) / $prev * 100;

        // Short Signal: RSI > 70 and price is starting to drop
        if ($rsi > 70 && $change1h < 0) {
            $takeProfit = calculateShortTP($entry, 3.0); // 3% drop
            $shortSignals[] = [
                'symbol' => $symbol,
                'rsi' => round($rsi, 2),
                '1hChange' => round($change1h, 2),
                'entryPrice' => round($entry, 6),
                'takeProfit' => round($takeProfit, 6)
            ];
        }
    }

    // Sort by highest RSI
  //  usort($shortSignals, fn($a, $b) => $b['rsi'] <=> $a['rsi']);
    usort($shortSignals, function($a, $b) {
        return $b['rsi'] <=> $a['rsi'];
    });
    return array_slice($shortSignals, 0, 2);
}

// Run and print top 2 short signals
$topShorts = analyzeShortSignals();

$apiToken ='7588381231:AAGP20hW3FjESpw_swAQFUrnoc8f03v7KHY'; 


foreach ($topShorts as $coin) {
           
    $html = "{$coin['symbol']} - RSI {$coin['rsi']}% - 1hrchange {$coin['1hChange']}% - Price: {$coin['entryPrice']} - TP : {$coin['takeProfit']} - Short \r\n";
    
    $data = [ 
     'chat_id' => '7964239235', 
     'text' => $html
    ]; 
     
    $response = file_get_contents('http://api.telegram.org/bot'.$apiToken.'/sendMessage?' . http_build_query($data) ); 
    
    echo $html;
}

