<?php
// === HELPER FUNCTION ===
function signedRequest($method, $endpoint, $params = [], $apiKey, $apiSecret)
{
    $timestamp = round(microtime(true) * 1000);
    $params['timestamp'] = $timestamp;

    $query = http_build_query($params, '', '&');
    $signature = hash_hmac('sha256', $query, $apiSecret);
    $query .= "&signature=" . $signature;

    $url = "https://fapi.binance.com" . $endpoint . "?" . $query;

    $headers = [
        "X-MBX-APIKEY: $apiKey"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new Exception('Curl error: ' . curl_error($ch));
    }
    curl_close($ch);

    return json_decode($response, true);
}