<?php
// === COMMON FUNCTION ===
function sendBitgetRequest($method, $endpoint, $body, $apiKey, $secretKey, $passphrase) {
    $baseUrl = 'https://api.bitget.com';
    $timestamp = round(microtime(true) * 1000);
    $url = $baseUrl . $endpoint;

    $bodyStr = $body ? json_encode($body, JSON_UNESCAPED_SLASHES) : '';
    if ($method === 'GET' && !empty($body)) {
        $query = http_build_query($body);
        $url .= '?' . $query;
        $preHash = $timestamp . $method . $endpoint . '?' . $query;
    } else {
        $preHash = $timestamp . $method . $endpoint . $bodyStr;
    }

    $sign = base64_encode(hash_hmac('sha256', $preHash, $secretKey, true));

    $headers = [
        'Content-Type: application/json',
        'ACCESS-KEY: ' . $apiKey,
        'ACCESS-SIGN: ' . $sign,
        'ACCESS-TIMESTAMP: ' . $timestamp,
        'ACCESS-PASSPHRASE: ' . $passphrase,
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $bodyStr);
    }

    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}