<?php
function getKlines($symbol, $interval = '1h', $limit = 100) {
    $url = "https://fapi.binance.com/fapi/v1/klines?symbol=$symbol&interval=$interval&limit=$limit";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function calculateSMA($data, $period) {
    $sma = [];
    for ($i = $period - 1; $i < count($data); $i++) {
        $sum = 0;
        for ($j = $i - $period + 1; $j <= $i; $j++) {
            $sum += $data[$j];
        }
        $sma[] = $sum / $period;
    }
    return $sma;
}

function calculateRSI($prices, $period = 14) {
    $gains = $losses = [];
    for ($i = 1; $i <= $period; $i++) {
        $diff = $prices[$i] - $prices[$i - 1];
        if ($diff >= 0) $gains[] = $diff;
        else $losses[] = abs($diff);
    }
    $avgGain = array_sum($gains) / $period;
    $avgLoss = array_sum($losses) / $period;
    if ($avgLoss == 0) return 100;
    $rs = $avgGain / $avgLoss;
    return 100 - (100 / (1 + $rs));
}

function calculateEMA($data, $period) {
    $ema = [];
    $k = 2 / ($period + 1);
    $ema[] = array_sum(array_slice($data, 0, $period)) / $period;
    for ($i = $period; $i < count($data); $i++) {
        $ema[] = $data[$i] * $k + end($ema) * (1 - $k);
    }
    return $ema;
}

function calculateMACD($prices, $fast = 12, $slow = 26, $signal = 9) {
    $emaFast = calculateEMA($prices, $fast);
    $emaSlow = calculateEMA($prices, $slow);
    $macdLine = [];
    $start = count($emaFast) - count($emaSlow); // align EMAs
    for ($i = 0; $i < count($emaSlow); $i++) {
        $macdLine[] = $emaFast[$i + $start] - $emaSlow[$i];
    }
    $signalLine = calculateEMA($macdLine, $signal);
    return [end($macdLine), end($signalLine)];
}

function getTopSymbolsByVolume($f = 0, $limit = 20) {
   // $url = "https://api.binance.com/api/v3/ticker/24hr";
    $url = "https://fapi.binance.com/fapi/v1/ticker/24hr";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($res, true);
    $filtered = array_filter($data, fn($d) => str_ends_with($d['symbol'], 'USDT') && !str_contains($d['symbol'], 'UP') && !str_contains($d['symbol'], 'DOWN'));
    usort($filtered, fn($a, $b) => floatval($b['quoteVolume']) <=> floatval($a['quoteVolume']));
    return array_slice(array_column($filtered, 'symbol'), $f, $limit);
}